package gov.va.genisis2Test.boImp;

import static org.mockito.Mockito.when;

import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.bo.ActivitiService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * @author Getaneh Kassahun
 *
 */

public class ActivitiServiceTest extends AbstractMockMvcTests {

	/** The logger. */
	protected final org.slf4j.Logger logger = LoggerFactory.getLogger(ActivitiServiceTest.class);

	/** User Id. */
	private final String userId = "datamanager1";

	/**
	 * This method is used to getUserId.
	 * @return This returns userId.
	 * 
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * This method is used to Test work flow process.
	 * @exception Exception On work flow process error.
	 */
	@Test
	public void startProcess() throws Exception {

		ActivitiService activitiService = getMockActivitiService();
		String processId = activitiService.startProcess(getUserId());
		when(activitiService.startProcess(getUserId())).thenReturn(processId);

	}

}
